const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_batchsummary_master2_Coating', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true,
    },
    PrdType: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    ReportType: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    BFGCode: {
      type: DataTypes.STRING(200),
      allowNull: true,
    },
    ProductName: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    CubicleType: {
      type: DataTypes.STRING(200),
      allowNull: true,
    },
    BatchNo: {
      type: DataTypes.STRING(200),
      allowNull: true,
    },
    BatchSize: {
      type: DataTypes.STRING(200),
      allowNull: true,
    },
    AvgValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    Remark: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    StartDate: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    EndDate: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    Unit: {
      type: DataTypes.STRING(5),
      allowNull: true,
    },
    Lot: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    BatchCompleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    StdTime: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    NoOfStations: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    LHSContainerNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    RHSContainerNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    MPN_Code: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    Make: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    Model: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    SerialNo: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    CoatingType: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    SprayPeriod: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    MesTestType: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    BatchStartTime: {
      type: DataTypes.STRING(80),
      allowNull: true,
    },
    BatchEndTime: {
      type: DataTypes.STRING(80),
      allowNull: true,
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    InstrumentID: {
      type: DataTypes.STRING(300),
      allowNull: true,
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
    },
    side: {
      type: DataTypes.STRING(200),
      allowNull: true,
     defaultValue: "NA"
    },
    CubicName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
  },
  {
    sequelize,
    tableName: 'tbl_batchsummary_master2_Coating',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: 'PK_tbl_batchsummary_master2_Coating',
        unique: true,
        fields: ['RepSerNo'],
      },
    ],
  });
};
